/*
todo:
    * Lägga till räknare som uppdateras av T1 overflow interrupt för att få löpande
	och mer långsiktig timestamp, istället för att nolla ICR.
    * Lägga in sekvensnummer tillsammans med mätta durationer?
    * Använd koll för riktigt korta pulser, ändring av nivå innan ICP-ICR klar,
	som i Atmels kodexempel, för att undvika flera pulser av samma polaritet
	i obruten följd.
    * Prescaler 256? upplösning 16 µs räcker gott och väl, och är lite mer finkornig
	än p1024. Räknare på 16 bitar ger 68719 sekunder, drygt 19 timmar.

    * Skriva funktion för att kolla om en duration ligger inom ett givet intervall.

Author: Johan Adler http://www.google.com/profiles/johan.adler

License: GNU/GPL v3
*/

// prescalers for timer 1

#define T1P_1		(				_BV(CS10))
#define T1P_8		(		_BV(CS11))
#define T1P_64		(		_BV(CS11) |	_BV(CS10))
#define T1P_256		(_BV(CS12))
#define T1P_1024	(_BV(CS12) |			_BV(CS10))

struct rxDataStruct {
  uint16_t dur;
  uint8_t lvl;
};

rxDataStruct icpRead();

/* prescalers for timer 1

Given system clock CK of 16 MHz:

presc	f(T1)	µs	tick->ms	rollover (ms)	(s)
1	16MHz	0,0625	tick >> 4	4,096		0,004
8	2MHz	0,5	tick >> 1	32,768		0,033
64	256kHz	4	tick << 2	262,144		0,262
256	64kHz	16	tick << 4	1048,576	1,049
1024	16kHz	64	tick << 6	4194,304	4,194

1 tick = presc/16 µs
*/

/*
  TFA:

  low: 970-1050 µs
  high: 450-750 µs (=1), 1250-1650 µs (=0)

  Basic timing
  ------------
  Signal train is preceded by about 32 ms low (i.e. radio silence)
  Long high signal measured as about 1250 to 1650 µs stands for a logic 0
  Short high signal measured as about 450 to 750 µs stands for a logic 1
  Between high signals the low part is about 970 to 1050 µs

  Prescaler 1024		256
  450 µs    7 ticks		28,125
  750 µs    12 t (11,7)		46,875
  970 µs    15 t		60,625
  1050	    16 t (16,4)		65,625
  1250	    19 t (19,53)	78,125
  1650	    26 t (25,78)	103,125

*/
