package org.ekblad.nexa;

import gnu.io.CommPortIdentifier;
import gnu.io.SerialPort;

import java.io.InputStream;

/**
 * Program for reading serial info from the USB (Where the Arduino board is connected and running the nexaDecoder program) and turn on/off a
 * NEXA power outlet. This program also assumes you have a tellstick (http://www.telldus.se/) connected and the tdtool program from telldus 
 * installed on your system. Also configure your /etc/tellstick.conf with something similar to (the program assumes you have id=1):
 * 
 * deviceNode = "/dev/tellstick"
 * device {
 * id = 1
 * name = "Kontakt 1"
 * protocol = "arctech"
 * model = "selflearning-switch"
 * parameters {
 *   house = "1001"
 *   unit = "1"
 *   }
 * }
 * 
 * You also need the rxtx library.
 * 
 * @author Johan Ekblad &lt;jka@ekblad.org&gt;
 * @license GNU/GPL v3
 *
 */

public class NexaControl {

	public static String remoteControlId="3212610";
	
	public static void main(String[] s)
	{
		try
		{
			
			/* list available ports 
			
			Enumeration portList = CommPortIdentifier.getPortIdentifiers();
			
			while (portList.hasMoreElements())
	        {
	               // Port Identifier.
	               CommPortIdentifier portId = (CommPortIdentifier) portList.nextElement();
	               // view the port.
	               System.out.println("Port --> " + portId.getName());
	        }
			System.exit(0);
	        */
			
			CommPortIdentifier portIdentifier = CommPortIdentifier.getPortIdentifier("/dev/ttyUSB0");
			if (portIdentifier.isCurrentlyOwned())
			{
				System.out.println("Port in use!");
			}
			else 
			{
				System.out.println(portIdentifier.getName());

				SerialPort serialPort = (SerialPort) portIdentifier.open("ListPortClass", 9600);
				int b = serialPort.getBaudRate();
				System.out.println(Integer.toString(b));
				//serialPort.setSerialPortParams(9600, SerialPort.DATABITS_8, SerialPort.STOPBITS_1, SerialPort.PARITY_NONE);
				//serialPort.setFlowControlMode(SerialPort.FLOWCONTROL_NONE);
				InputStream mInputFromPort = serialPort.getInputStream();
				
				while (true)
				{
				
					System.out.println("Waiting for data");
				
					while (mInputFromPort.available() == 0)
					{
						try
						{
							Thread.sleep(10);
						}
						catch (Exception e)
						{
						
						}
					}
					
					// Sleep for a while to collect all data in message!
					
					try
					{
						Thread.sleep(100);
					}
					catch (Exception e)
					{
					
					}
				
					byte inBytes[] = new byte[300];
				
					mInputFromPort.read(inBytes, 0, mInputFromPort.available());

					String data=new String(inBytes);
					if (data.indexOf("House:"+remoteControlId)> 0 && data.indexOf("Unit:0") > 0) // First unit pressed on my remote
					{
						String cmd="--off";
					    if (data.indexOf("Mode:1") > 0) // Turn on
					    {
					    	cmd="--on";
					    }
					    String cmdstr="tdtool "+cmd+" 1";
					    System.out.println(cmdstr);
					    Runtime run = Runtime.getRuntime() ;
					    Process pr = run.exec(cmdstr) ;
					    pr.waitFor() ;
					}
					System.out.println("Got String:"+new String(inBytes));
					
				
				}
			
			}
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}
		
	}
}
